state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local portal_in = resize.location.portal_in
local portal_out = resize.location.portal_out
local mirror_in = resize.location.input
local mirror_out = resize.location.output

function is_portal_selected()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialCreatePortal" or partial.type == "PartialRelinkPortal"
end
local function only_open_portal(i)
  return i == PlayerInteraction.place_portal;
end
local allow_click = function()
  return false
end
local function is_mouse_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click then
      return allow_click()
    end
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  end
  return false
end
local function is_rotation_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.scroll_up or i.event == MouseEventAction.scroll_down then
      return true
    end
  else
    return i == PlayerInteraction.rotate_right or i == PlayerInteraction.rotate_left
  end
  return false
end
local function is_flip_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.mmb_click then
      return true
    end
  else
    return i == PlayerInteraction.flip
  end
  return false
end
local function allow_portal_click()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return portal_in:contains(partial.input)
  elseif partial.type == "PartialRelinkPortal" then
    if partial.output_orientation == F1 then
      return partial.output == portal_out.lesser
    end
  end
  return false
end
function is_done()
  for v in each_vector(portal_in) do
    if state.grid:at(v) == nil then
      return false
    end
  end
  for v in each_vector(portal_out) do
    if state.grid:at(v) == nil then
      return false
    end
  end
  return true
end
local function is_setting_portal_input()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreatePortal" then
    return partial.output == nil
  end
  return false
end
local function is_setting_portal_output()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialRelinkPortal" then
    return partial.output ~= nil
  end
  return false
end
local function is_portal_output_flipped()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialRelinkPortal" then
    return partial.output_orientation == F1
  end
end
local function is_portal_output_rotated()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialRelinkPortal" then
    return partial.output_orientation == F1 or partial.output_orientation == R1
  end
end

function tutorial_routine()
  return coroutine.wrap(function()
    if not is_done() then
      set_user_input_filter(restrictive_filter)
      embed(announce("The last level can be done faster.", 3, 0.1, captured_cancel()))
      embed(pause(0.2))
      embed(ramp(3, do_all(
        announce_lambda("This portal is disconnected", 0.1),
        bouncing_arrow_at_game_lambda(portal_in, 0.06, DOWN),
        glowing_box_at_game_lambda(portal_in)
      ), captured_cancel()))
      embed(pause(0.2))
      embed(ramp(3, do_all(
        announce_lambda("We want to connect it here", 0.1),
        bouncing_arrow_at_game_lambda(portal_out, 0.06, RIGHT),
        glowing_box_at_game_lambda(portal_out)
      ), captured_cancel()))
      embed(pause(0.2))
      embed(ramp(3, do_all(
        announce_lambda("The new portal must flip and rotate objects", 0.07),
        blinking_box_at_game_lambda(mirror_in),
        blinking_box_at_game_lambda(mirror_out)
      ), captured_cancel()))
    end
    state:suppress_toolbar_menu(false)
    while not is_done() do
      set_user_input_filter(only_open_portal)
      embed(ramp_until(is_portal_selected, do_all(
        highlight_menu_item_lambda("toolbar_3"),
        announce_lambda("Tool: Portal", 0.15))
      ))
      set_user_input_filter(lifted_or(is_mouse_interaction, is_flip_interaction, is_rotation_interaction))
      allow_click = allow_portal_click
      embed(ramp_while(is_setting_portal_input, do_all(
        announce_lambda("Click on the disconnected portal.", 0.1),
        bouncing_arrow_at_game_lambda(portal_in, 0.06, DOWN),
        glowing_box_at_game_lambda(portal_in)
      )))
      embed(ramp_while(
        lifted_and(
          is_setting_portal_output,
          lifted_not(is_portal_output_rotated)
        ),
        do_all(
          announce_lambda("Press E or R to rotate.", 0.15),
          announce_lambda("(Or scroll with mouse)", 0.08, -0.15)
        )
      ))
      embed(ramp_while(
        lifted_and(
          is_setting_portal_output,
          is_portal_output_rotated,
          lifted_not(is_portal_output_flipped)
        ),
        do_all(
          announce_lambda("Press F to flip", 0.15, -0.08),
          announce_lambda("(Or middle mouse click)", 0.08, -0.2)
        )
      ))
      embed(ramp_while(
        lifted_and(
          is_setting_portal_output,
          is_portal_output_flipped_any,
          is_portal_output_flipped
        ),
        do_all(
          announce_lambda("Place output here.", 0.15),
          bouncing_arrow_at_game_lambda(portal_out, 0.06, RIGHT),
          glowing_box_at_game_lambda(portal_out)
        )
      ))
      embed(pause(0.01))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    embed(ramp_while(is_portal_selected, announce_lambda("Right click to exit portal tool", 0.08)))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
  end)
end

draw_interpreted_routine(tutorial_routine())
